#pragma once

#include <set>

#include "LD10Types.h"



class Level;

class GameObject
{

  public:

    LD10::TextureTypes      m_Texture;
    LD10::GameObjectType    m_Type;

    std::set<int>           m_PushedByThese;

    int                     m_DispX;
    int                     m_DispY;
    float                   m_FractX;
    float                   m_FractY;

    float                   m_SpeedX;
    float                   m_SpeedY;
    float                   m_AccX;
    float                   m_AccY;
    float                   m_Angle;

    float                   m_LifeTime;

    bool                    m_RemoveMe;

    int                     m_Number;

    int                     m_ObjIndex;


    GameObject();
    ~GameObject();

    void                    Render();
    void                    RenderShadow();
    void                    RenderFX();
    void                    Update( float ElapsedTime, Level& theLevel );
    void                    UpdatePhysicsStep( Level& theLevel );

};
